/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.wd.SharedProxy;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.config.CommonConfig;
import net.montoyo.wd.controls.builtin.ClickControl;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.data.ScreenConfigData;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.init.ItemInit;
import net.montoyo.wd.init.TileInit;
import net.montoyo.wd.miniserv.SyncPlugin;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.client_bound.S2CMessageAddScreen;
import net.montoyo.wd.net.client_bound.S2CMessageCloseGui;
import net.montoyo.wd.net.client_bound.S2CMessageJSResponse;
import net.montoyo.wd.net.client_bound.S2CMessageScreenUpdate;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.MutableAABB;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.NibbleArray;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.ScreenIterator;
import net.montoyo.wd.utilities.TypeData;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;
import net.montoyo.wd.utilities.VideoType;

public class TileEntityScreen
extends BlockEntity {
    private final ArrayList<Screen> screens = new ArrayList();
    private AABB renderBB = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private boolean loaded = true;
    public float ytVolume = Float.POSITIVE_INFINITY;

    public TileEntityScreen(BlockPos arg2, BlockState arg3) {
        super((BlockEntityType)TileInit.SCREEN_BLOCK_ENTITY.get(), arg2, arg3);
    }

    public void forEachScreenBlocks(BlockSide side, Consumer<BlockPos> func) {
        Screen scr = this.getScreen(side);
        if (scr != null) {
            ScreenIterator it = new ScreenIterator(this.m_58899_(), side, scr.size);
            while (it.hasNext()) {
                func.accept(it.next());
            }
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
    }

    public void unload() {
        for (Screen scr : this.screens) {
            if (scr.browser == null) continue;
            scr.browser.close();
            scr.browser = null;
        }
        this.loaded = false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag list = tag.m_128437_("WDScreens", 10);
        if (list.isEmpty()) {
            return;
        }
        this.screens.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.screens.add(Screen.deserialize(list.m_128728_(i)));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
        for (Screen screen : this.screens) {
            if (screen.browser == null) {
                screen.createBrowser(false);
            }
            if (screen.browser == null) continue;
            screen.browser.loadURL(screen.url);
        }
        this.updateAABB();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (Screen scr : this.screens) {
            list.add((Object)scr.serialize());
        }
        tag.m_128365_("WDScreens", (Tag)list);
    }

    public Screen addScreen(BlockSide side, Vector2i size, @Nullable Vector2i resolution, @Nullable Player owner, boolean sendUpdate) {
        for (Screen scr : this.screens) {
            if (scr.side != side) continue;
            return scr;
        }
        Screen ret = new Screen();
        ret.side = side;
        ret.size = size;
        ret.url = CommonConfig.Browser.homepage;
        ret.friends = new ArrayList();
        ret.friendRights = 51;
        ret.otherRights = 51;
        ret.upgrades = new ArrayList();
        if (owner != null) {
            ret.owner = new NameUUIDPair(owner.m_36316_());
            if (side == BlockSide.TOP || side == BlockSide.BOTTOM) {
                int rot = (int)Math.floor((double)(owner.m_146908_() * 4.0f / 360.0f) + 2.5) & 3;
                if (side == BlockSide.TOP) {
                    if (rot == 1) {
                        rot = 3;
                    } else if (rot == 3) {
                        rot = 1;
                    }
                }
                ret.rotation = Rotation.values()[rot];
            }
        }
        if (resolution == null || resolution.x < 1 || resolution.y < 1) {
            float psx = (float)size.x * 16.0f - 4.0f;
            float psy = (float)size.y * 16.0f - 4.0f;
            ret.resolution = new Vector2i((int)(psx *= 8.0f), (int)(psy *= 8.0f));
        } else {
            ret.resolution = resolution;
        }
        ret.clampResolution();
        if (!this.f_58857_.f_46443_) {
            ret.setupRedstoneStatus(this.f_58857_, this.m_58899_());
            if (sendUpdate) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)new S2CMessageAddScreen(this, ret));
            }
        }
        this.screens.add(ret);
        if (this.f_58857_.f_46443_) {
            this.updateAABB();
        } else {
            this.m_6596_();
        }
        return ret;
    }

    public Screen getScreen(BlockSide side) {
        for (Screen scr : this.screens) {
            if (scr.side != side) continue;
            return scr;
        }
        return null;
    }

    public int screenCount() {
        return this.screens.size();
    }

    public Screen getScreen(int idx) {
        return this.screens.get(idx);
    }

    public void clear() {
        this.screens.clear();
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public void requestData(ServerPlayer ep) {
        if (!this.f_58857_.f_46443_) {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> ep), (Object)new S2CMessageAddScreen(this));
        }
    }

    public static String url(String url) throws IOException {
        System.out.println("URL received: " + url);
        if (!(WebDisplays.PROXY instanceof ClientProxy)) {
            List serverPlayers = WebDisplays.PROXY.getServer().m_6846_().m_11314_();
            SyncPlugin.syncPlayers(serverPlayers);
            for (ServerPlayer serverPlayer : serverPlayers) {
                SyncPlugin.setPlayerString(serverPlayer, url);
            }
            return url;
        }
        return url;
    }

    public void setScreenURL(BlockSide side, String url) throws IOException {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt to change URL of non-existing screen on side %s", side.toString());
            return;
        }
        String weburl = TileEntityScreen.url(url);
        scr.url = weburl = WebDisplays.applyBlacklist(weburl);
        scr.videoType = VideoType.getTypeFromURL(weburl);
        if (this.f_58857_.f_46443_) {
            if (scr.browser != null) {
                scr.browser.loadURL(weburl);
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.setURL(this, side, weburl));
            this.m_6596_();
        }
    }

    public void removeScreen(BlockSide side) {
        int idx = -1;
        for (int i = 0; i < this.screens.size(); ++i) {
            if (this.screens.get((int)i).side != side) continue;
            idx = i;
            break;
        }
        if (idx < 0) {
            Log.error("Tried to delete non-existing screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (this.screens.get((int)idx).browser != null) {
                this.screens.get((int)idx).browser.close();
                this.screens.get((int)idx).browser = null;
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)new S2CMessageScreenUpdate(this.m_58899_(), side));
        }
        this.screens.remove(idx);
        if (!this.f_58857_.f_46443_) {
            if (this.screens.isEmpty()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)((BlockScreen)((Object)BlockInit.blockScreen.get())).m_49966_().m_61124_((Property)BlockScreen.hasTE, (Comparable)Boolean.valueOf(false)));
            } else {
                this.m_6596_();
            }
        }
    }

    public void setResolution(BlockSide side, Vector2i res) {
        if (res.x < 1 || res.y < 1) {
            Log.warning("Call to TileEntityScreen.setResolution(%s) with suspicious values X=%d and Y=%d", side.toString(), res.x, res.y);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to change resolution of non-existing screen on side %s", side.toString());
            return;
        }
        scr.resolution = res;
        scr.clampResolution();
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.screenUpdateResolutionInGui(new Vector3i(this.m_58899_()), side, res);
            if (scr.browser != null) {
                scr.browser.close();
                scr.browser = null;
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.setResolution(this, side, res));
            this.m_6596_();
        }
    }

    private static Player getLaserUser(Screen scr) {
        if (scr.laserUser != null && (scr.laserUser.m_213877_() || !scr.laserUser.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(ItemInit.LASER_POINTER.get()))) {
            scr.laserUser = null;
        }
        return scr.laserUser;
    }

    private static void checkLaserUserRights(Screen scr) {
        if (scr.laserUser != null && (scr.rightsFor(scr.laserUser) & 2) == 0) {
            scr.laserUser = null;
        }
    }

    public void clearLaserUser(BlockSide side) {
        Screen scr = this.getScreen(side);
        if (scr != null) {
            scr.laserUser = null;
        }
    }

    public void click(BlockSide side, Vector2i vec) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt click non-existing screen of side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            Log.warning("TileEntityScreen.click() from client side is useless...", new Object[0]);
        } else if (TileEntityScreen.getLaserUser(scr) == null) {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.CLICK, vec));
        }
    }

    void clickUnsafe(BlockSide side, ClickControl.ControlType action, int x, int y) {
        if (this.f_58857_.f_46443_) {
            Vector2i vec = action == ClickControl.ControlType.UP ? null : new Vector2i(x, y);
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, action, vec));
        }
    }

    public void handleMouseEvent(BlockSide side, ClickControl.ControlType event, @Nullable Vector2i vec, int button) {
        if (button > 1) {
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt inject mouse events on non-existing screen of side %s", side.toString());
            return;
        }
        if (scr.browser != null) {
            if (event == ClickControl.ControlType.CLICK) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, button, true, 1);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, button, false, 1);
            } else if (event == ClickControl.ControlType.DOWN) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, button, true, 1);
            } else if (event == ClickControl.ControlType.MOVE) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
            } else if (event == ClickControl.ControlType.UP) {
                scr.browser.injectMouseButton(scr.lastMousePos.x, scr.lastMousePos.y, 0, button, false, 1);
            }
            if (vec != null) {
                scr.lastMousePos.x = vec.x;
                scr.lastMousePos.y = vec.y;
            }
        }
    }

    public void updateJSRedstone(BlockSide side, Vector2i vec, int redstoneLevel) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called updateJSRedstone on non-existing side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (scr.browser != null) {
                scr.browser.runJS("if(typeof webdisplaysRedstoneCallback == \"function\") webdisplaysRedstoneCallback(" + vec.x + ", " + vec.y + ", " + redstoneLevel + ");", "");
            }
        } else {
            boolean sendMsg = false;
            if (scr.redstoneStatus == null) {
                scr.setupRedstoneStatus(this.f_58857_, this.m_58899_());
                sendMsg = true;
            } else {
                int idx = vec.y * scr.size.x + vec.x;
                if (scr.redstoneStatus.get(idx) != redstoneLevel) {
                    scr.redstoneStatus.set(idx, redstoneLevel);
                    sendMsg = true;
                }
            }
        }
    }

    public void handleJSRequest(ServerPlayer src, BlockSide side, int reqId, JSServerRequest req, Object[] data) {
        if (this.f_58857_.f_46443_) {
            Log.error("Called handleJSRequest client-side", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called handleJSRequest on non-existing side %s", side.toString());
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new S2CMessageJSResponse(reqId, req, 403, "Invalid side"));
            return;
        }
        if (!scr.owner.uuid.equals(src.m_36316_().getId())) {
            Log.warning("Player %s (UUID %s) tries to use the redstone output API on a screen he doesn't own!", src.m_7755_(), src.m_36316_().getId().toString());
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new S2CMessageJSResponse(reqId, req, 403, "Only the owner can do that"));
            return;
        }
        if (scr.upgrades.stream().noneMatch(DefaultUpgrade.REDOUTPUT::matchesRedInput)) {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new S2CMessageJSResponse(reqId, req, 403, "Missing upgrade"));
            return;
        }
        if (req == JSServerRequest.CLEAR_REDSTONE) {
            BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
            Vector3i vec1 = new Vector3i(this.m_58899_());
            Vector3i vec2 = new Vector3i();
            for (int y = 0; y < scr.size.y; ++y) {
                vec2.set(vec1);
                for (int x = 0; x < scr.size.x; ++x) {
                    vec2.toBlock(mbp);
                    BlockState bs = this.f_58857_.m_8055_((BlockPos)mbp);
                    if (((Boolean)bs.m_61143_((Property)BlockScreen.emitting)).booleanValue()) {
                        this.f_58857_.m_7731_((BlockPos)mbp, (BlockState)bs.m_61124_((Property)BlockScreen.emitting, (Comparable)Boolean.valueOf(false)), 11);
                    }
                    vec2.add(side.right.x, side.right.y, side.right.z);
                }
                vec1.add(side.up.x, side.up.y, side.up.z);
            }
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new S2CMessageJSResponse(reqId, req, new byte[0]));
        } else if (req == JSServerRequest.SET_REDSTONE_AT) {
            int x = (Integer)data[0];
            int y = (Integer)data[1];
            boolean state = (Boolean)data[2];
            if (x < 0 || x >= scr.size.x || y < 0 || y >= scr.size.y) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new S2CMessageJSResponse(reqId, req, 403, "Out of range"));
            } else {
                BlockPos bp = new Vector3i(this.m_58899_()).addMul(side.right, x).addMul(side.up, y).toBlock();
                BlockState bs = this.f_58857_.m_8055_(bp);
                if (!((Boolean)bs.m_61143_((Property)BlockScreen.emitting)).equals(state)) {
                    this.f_58857_.m_46597_(bp, (BlockState)bs.m_61124_((Property)BlockScreen.emitting, (Comparable)Boolean.valueOf(state)));
                }
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new S2CMessageJSResponse(reqId, req, new byte[0]));
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> src), (Object)new S2CMessageJSResponse(reqId, req, 400, "Invalid request"));
        }
    }

    public void onLoad() {
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.trackScreen(this, true);
        }
    }

    public void onChunkUnloaded() {
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.trackScreen(this, false);
            for (Screen scr : this.screens) {
                if (scr.browser == null) continue;
                scr.browser.close();
                scr.browser = null;
            }
        }
    }

    private void updateAABB() {
        Vector3i origin = new Vector3i(this.m_58899_());
        MutableAABB box = null;
        for (Screen scr : this.screens) {
            Vector3i f = scr.side.forward;
            int fx = Math.max(f.x, 0);
            int fy = Math.max(f.y, 0);
            int fz = Math.max(f.z, 0);
            int ox = 0;
            if (scr.side.equals((Object)BlockSide.NORTH)) {
                ox = 1;
            }
            int oz = 0;
            if (scr.side.equals((Object)BlockSide.EAST) || scr.side.equals((Object)BlockSide.TOP) || scr.side.equals((Object)BlockSide.BOTTOM)) {
                oz = 1;
            }
            if (box == null) {
                box = new MutableAABB(origin.x + fx + ox, origin.y + fy, origin.z + fz + oz, origin.x + ox + scr.side.right.x * scr.size.x + fx + scr.side.up.x * scr.size.y, origin.y + scr.side.right.y * scr.size.x + fy + scr.side.up.y * scr.size.y, origin.z + oz + scr.side.right.z * scr.size.x + fz + scr.side.up.z * scr.size.y);
                continue;
            }
            box.expand(origin.x + fx + ox, origin.y + fy, origin.z + fz + oz, origin.x + ox + scr.side.right.x * scr.size.x + fx + scr.side.up.x * scr.size.y, origin.y + scr.side.right.y * scr.size.x + fy + scr.side.up.y * scr.size.y, origin.z + oz + scr.side.right.z * scr.size.x + fz + scr.side.up.z * scr.size.y);
        }
        this.renderBB = box == null ? new AABB(this.f_58858_) : box.toMc();
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        return this.renderBB;
    }

    public void updateTrackDistance(double d, float masterVolume) {
        WebDisplays wd = WebDisplays.INSTANCE;
        boolean needsComputation = true;
        int intPart = 0;
        int fracPart = 0;
        for (Screen scr : this.screens) {
            if (!scr.autoVolume || scr.videoType == null || scr.browser == null || scr.browser.isPageLoading()) continue;
            if (needsComputation) {
                float dist = (float)Math.sqrt(d);
                float vol = dist <= wd.avDist100 ? masterVolume * wd.ytVolume : (dist >= wd.avDist0 ? 0.0f : (1.0f - (dist - wd.avDist100) / (wd.avDist0 - wd.avDist100)) * masterVolume * wd.ytVolume);
                if (Math.abs(this.ytVolume - vol) < 0.5f) {
                    return;
                }
                this.ytVolume = vol;
                intPart = (int)vol;
                fracPart = (int)(vol * 100.0f) - intPart * 100;
                needsComputation = false;
            }
            scr.browser.runJS(scr.videoType.getVolumeJSQuery(intPart, fracPart), "");
        }
    }

    public void updateClientSideURL(IBrowser target, String url) {
        for (Screen scr : this.screens) {
            if (scr.browser != target) continue;
            try {
                String webUrl = TileEntityScreen.url(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            boolean blacklisted = WebDisplays.isSiteBlacklisted(url);
            scr.url = blacklisted ? "mod://webdisplays/blacklisted.html" : url;
            scr.videoType = VideoType.getTypeFromURL(scr.url);
            this.ytVolume = Float.POSITIVE_INFINITY;
            if (!blacklisted || scr.browser == null) break;
            scr.browser.loadURL("mod://webdisplays/blacklisted.html");
            break;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.f_58857_.f_46443_) {
            this.onChunkUnloaded();
        }
    }

    public void addFriend(ServerPlayer ply, BlockSide side, NameUUIDPair pair) {
        if (!this.f_58857_.f_46443_) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to add friend to invalid screen side %s", side.toString());
                return;
            }
            if (!scr.friends.contains(pair)) {
                scr.friends.add(pair);
                new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(BlockPeripheral.point(this.f_58857_, this.m_58899_()));
                this.m_6596_();
            }
        }
    }

    public void removeFriend(ServerPlayer ply, BlockSide side, NameUUIDPair pair) {
        if (!this.f_58857_.f_46443_) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to remove friend from invalid screen side %s", side.toString());
                return;
            }
            if (scr.friends.remove(pair)) {
                TileEntityScreen.checkLaserUserRights(scr);
                new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(BlockPeripheral.point(this.f_58857_, this.m_58899_()));
                this.m_6596_();
            }
        }
    }

    public void setRights(ServerPlayer ply, BlockSide side, int fr, int or) {
        if (!this.f_58857_.f_46443_) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to change rights of invalid screen on side %s", side.toString());
                return;
            }
            scr.friendRights = fr;
            scr.otherRights = or;
            TileEntityScreen.checkLaserUserRights(scr);
            new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(BlockPeripheral.point(this.f_58857_, this.m_58899_()));
            this.m_6596_();
        }
    }

    public void type(BlockSide side, String text, BlockPos soundPos) {
        this.type(side, text, soundPos, null);
    }

    public void type(BlockSide side, String text, BlockPos soundPos, @Nullable ServerPlayer sender) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to type on invalid screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (scr.browser != null) {
                try {
                    TypeData[] data;
                    if (text.startsWith("t")) {
                        char chr;
                        for (int i = 1; i < text.length() && (chr = text.charAt(i)) != '\u0001'; ++i) {
                            scr.browser.injectKeyTyped((int)chr, 0);
                        }
                    }
                    block8: for (TypeData ev : data = (TypeData[])WebDisplays.GSON.fromJson(text, TypeData[].class)) {
                        if (ev.getKeyCode() == 257) {
                            ev = new TypeData(ev.getAction(), 10, ev.getModifier());
                        }
                        switch (ev.getAction()) {
                            case PRESS: {
                                scr.browser.injectKeyPressedByKeyCode(ev.getKeyCode(), (char)ev.getKeyCode(), ev.getModifier());
                                if (ev.getKeyCode() != 10) continue block8;
                                scr.browser.injectKeyTyped(13, ev.getModifier());
                                continue block8;
                            }
                            case RELEASE: {
                                scr.browser.injectKeyReleasedByKeyCode(ev.getKeyCode(), (char)ev.getKeyCode(), ev.getModifier());
                                continue block8;
                            }
                            case TYPE: {
                                scr.browser.injectKeyTyped(ev.getKeyCode(), ev.getModifier());
                                continue block8;
                            }
                            default: {
                                throw new RuntimeException("Invalid type action '" + ev.getAction() + "'");
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    Log.warningEx("Suspicious keyboard type packet received...", t, new Object[0]);
                }
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(sender != null ? () -> BlockPeripheral.point((Player)sender, this.f_58857_, this.m_58899_()) : () -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.type(this, side, text));
            if (soundPos != null) {
                this.playSoundAt(WebDisplays.INSTANCE.soundTyping, soundPos, 0.25f, 1.0f);
            }
        }
    }

    private void playSoundAt(SoundEvent snd, BlockPos at, float vol, float pitch) {
        double x = at.m_123341_();
        double y = at.m_123342_();
        double z = at.m_123343_();
        this.f_58857_.m_6263_(null, x + 0.5, y + 0.5, z + 0.5, snd, SoundSource.BLOCKS, vol, pitch);
    }

    public void updateUpgrades(BlockSide side, ItemStack[] upgrades) {
        if (!this.f_58857_.f_46443_) {
            Log.error("Tried to call TileEntityScreen.updateUpgrades() from server side...", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to update upgrades on invalid screen on side %s", side.toString());
            return;
        }
        scr.upgrades.clear();
        Collections.addAll(scr.upgrades, upgrades);
        if (scr.browser != null) {
            scr.browser.runJS("if(typeof webdisplaysUpgradesChanged == \"function\") webdisplaysUpgradesChanged();", "");
        }
    }

    private static String safeName(ItemStack is) {
        return is.m_41720_().m_7626_(is).getString();
    }

    public boolean addUpgrade(BlockSide side, ItemStack is, @Nullable Player player, boolean abortIfExisting) {
        if (this.f_58857_.f_46443_) {
            IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
            Screen scr = this.getScreen(side);
            ItemStack isCopy = is.m_41777_();
            scr.upgrades.add(isCopy);
            itemAsUpgrade.onInstall(this, side, player, isCopy);
            return false;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to add an upgrade on invalid screen on side %s", side.toString());
            return false;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            Log.error("Tried to add a non-upgrade item %s to screen (%s does not implement IUpgrade)", TileEntityScreen.safeName(is), is.m_41720_().getClass().getCanonicalName());
            return false;
        }
        if (scr.upgrades.size() >= 16) {
            Log.error("Can't insert upgrade %s in screen %s at %s: too many upgrades already!", TileEntityScreen.safeName(is), side.toString(), this.m_58899_().toString());
            return false;
        }
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        if (abortIfExisting && scr.upgrades.stream().anyMatch(otherStack -> itemAsUpgrade.isSameUpgrade(is, (ItemStack)otherStack))) {
            return false;
        }
        ItemStack isCopy = is.m_41777_();
        isCopy.m_41764_(1);
        scr.upgrades.add(isCopy);
        if (player != null && !player.f_19853_.f_46443_) {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.upgrade(this, side, true, is));
            itemAsUpgrade.onInstall(this, side, player, isCopy);
            this.playSoundAt(WebDisplays.INSTANCE.soundUpgradeAdd, this.m_58899_(), 1.0f, 1.0f);
        }
        this.m_6596_();
        return true;
    }

    public boolean hasUpgrade(BlockSide side, ItemStack is) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            return false;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            return false;
        }
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        return scr.upgrades.stream().anyMatch(otherStack -> itemAsUpgrade.isSameUpgrade(is, (ItemStack)otherStack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasUpgrade(BlockSide side, DefaultUpgrade du) {
        Screen scr = this.getScreen(side);
        if (du == DefaultUpgrade.LASERMOUSE) {
            if (scr == null) return false;
            if (!scr.upgrades.stream().anyMatch(du::matchesLaserMouse)) return false;
            return true;
        }
        if (du == DefaultUpgrade.REDINPUT) {
            if (scr == null) return false;
            if (!scr.upgrades.stream().anyMatch(du::matchesRedInput)) return false;
            return true;
        }
        if (du == DefaultUpgrade.GPS) {
            if (scr == null) return false;
            if (!scr.upgrades.stream().anyMatch(du::matchesGps)) return false;
            return true;
        }
        if (du != DefaultUpgrade.REDOUTPUT) return false;
        if (scr == null) return false;
        if (!scr.upgrades.stream().anyMatch(du::matchesRedOutput)) return false;
        return true;
    }

    public void removeUpgrade(BlockSide side, ItemStack is, @Nullable Player player) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to remove an upgrade on invalid screen on side %s", side.toString());
            return;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            Log.error("Tried to remove a non-upgrade item %s to screen (%s does not implement IUpgrade)", TileEntityScreen.safeName(is), is.m_41720_().getClass().getCanonicalName());
            return;
        }
        int idxToRemove = -1;
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        for (int i = 0; i < scr.upgrades.size(); ++i) {
            if (!itemAsUpgrade.isSameUpgrade(is, scr.upgrades.get(i))) continue;
            idxToRemove = i;
            break;
        }
        if (idxToRemove >= 0) {
            this.dropUpgrade(scr.upgrades.get(idxToRemove), side, player);
            scr.upgrades.remove(idxToRemove);
            if (player != null && !player.f_19853_.f_46443_) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.upgrade(this, side, false, is));
                this.playSoundAt(WebDisplays.INSTANCE.soundUpgradeDel, this.m_58899_(), 1.0f, 1.0f);
            }
            this.m_6596_();
        } else {
            Log.warning("Tried to remove non-existing upgrade %s to screen %s at %s", TileEntityScreen.safeName(is), side.toString(), this.m_58899_().toString());
        }
    }

    private void dropUpgrade(ItemStack is, BlockSide side, @Nullable Player ply) {
        if (!((IUpgrade)is.m_41720_()).onRemove(this, side, ply, is)) {
            boolean spawnDrop = true;
            if (ply != null && (ply.m_7500_() || ply.m_36356_(is))) {
                spawnDrop = false;
            }
            if (spawnDrop) {
                Vector3f pos = new Vector3f(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
                pos.addMul(side.backward.toFloat(), 1.5f);
                if (this.f_58857_ != null) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)pos.x, (double)pos.y, (double)pos.z, is));
                }
            }
        }
    }

    private Screen getScreenForLaserOp(BlockSide side, Player ply) {
        if (this.f_58857_.f_46443_) {
            return null;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called laser operation on invalid screen on side %s", side.toString());
            return null;
        }
        if ((scr.rightsFor(ply) & 2) == 0) {
            return null;
        }
        if (scr.upgrades.stream().noneMatch(DefaultUpgrade.LASERMOUSE::matchesLaserMouse)) {
            Log.error("Called laser operation on side %s, but it's missing the laser sensor upgrade", side.toString());
            return null;
        }
        return scr;
    }

    public void laserDownMove(BlockSide side, Player ply, Vector2i pos, boolean down, int button) {
        Screen scr = this.getScreenForLaserOp(side, ply);
        if (scr != null) {
            if (button == -1) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(ply, this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.MOVE, pos));
            } else if (down) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(ply, this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.DOWN, pos));
            } else {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(ply, this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.UP, pos));
            }
        }
    }

    public void laserUp(BlockSide side, Player ply, int button) {
        Screen scr = this.getScreenForLaserOp(side, ply);
        if (scr != null && TileEntityScreen.getLaserUser(scr) == ply) {
            scr.laserUser = null;
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(ply, this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.UP, null));
        }
    }

    public void onDestroy(@Nullable Player ply) {
        for (Screen scr : this.screens) {
            scr.upgrades.forEach(is -> this.dropUpgrade((ItemStack)is, scr.side, ply));
            scr.upgrades.clear();
        }
        WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)new S2CMessageCloseGui(this.m_58899_()));
    }

    public void setOwner(BlockSide side, Player newOwner) {
        if (this.f_58857_.f_46443_) {
            Log.error("Called TileEntityScreen.setOwner() on client...", new Object[0]);
            return;
        }
        if (newOwner == null) {
            Log.error("Called TileEntityScreen.setOwner() with null owner", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called TileEntityScreen.setOwner() on invalid screen on side %s", side.toString());
            return;
        }
        scr.owner = new NameUUIDPair(newOwner.m_36316_());
        WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.owner(this, side, scr.owner));
        TileEntityScreen.checkLaserUserRights(scr);
        this.m_6596_();
    }

    public void setRotation(BlockSide side, Rotation rot) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to change rotation of invalid screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            boolean oldWasVertical = scr.rotation.isVertical;
            scr.rotation = rot;
            WebDisplays.PROXY.screenUpdateRotationInGui(new Vector3i(this.m_58899_()), side, rot);
            if (scr.browser != null && oldWasVertical != rot.isVertical) {
                scr.browser.close();
                scr.browser = null;
            }
        } else {
            scr.rotation = rot;
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.rotation(this, side, rot));
            this.m_6596_();
        }
    }

    public void evalJS(BlockSide side, String code) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to run JS code on invalid screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_ && scr.browser != null) {
            scr.browser.runJS(code, "");
        }
    }

    public void setAutoVolume(BlockSide side, boolean av) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to toggle auto-volume on invalid screen (side %s)", side.toString());
            return;
        }
        scr.autoVolume = av;
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.screenUpdateAutoVolumeInGui(new Vector3i(this.m_58899_()), side, av);
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.autoVolume(this, side, av));
            this.m_6596_();
        }
    }

    public static class Screen {
        public BlockSide side;
        public Vector2i size;
        public Vector2i resolution;
        public Rotation rotation = Rotation.ROT_0;
        public String url;
        private VideoType videoType;
        public NameUUIDPair owner;
        public ArrayList<NameUUIDPair> friends;
        public int friendRights;
        public int otherRights;
        public IBrowser browser;
        public ArrayList<ItemStack> upgrades;
        public boolean doTurnOnAnim;
        public long turnOnTime;
        public Player laserUser;
        public final Vector2i lastMousePos = new Vector2i();
        public NibbleArray redstoneStatus;
        public boolean autoVolume = true;
        public int mouseType;

        public static Screen deserialize(CompoundTag tag) {
            Screen ret = new Screen();
            ret.side = BlockSide.values()[tag.m_128445_("Side")];
            ret.size = new Vector2i(tag.m_128451_("Width"), tag.m_128451_("Height"));
            ret.resolution = new Vector2i(tag.m_128451_("ResolutionX"), tag.m_128451_("ResolutionY"));
            ret.rotation = Rotation.values()[tag.m_128445_("Rotation")];
            ret.url = tag.m_128461_("URL");
            ret.videoType = VideoType.getTypeFromURL(ret.url);
            if (ret.resolution.x <= 0 || ret.resolution.y <= 0) {
                float psx = (float)ret.size.x * 16.0f - 4.0f;
                float psy = (float)ret.size.y * 16.0f - 4.0f;
                ret.resolution.x = (int)(psx *= 8.0f);
                ret.resolution.y = (int)(psy *= 8.0f);
            }
            if (tag.m_128441_("OwnerName")) {
                String name = tag.m_128461_("OwnerName");
                UUID uuid = tag.m_128342_("OwnerUUID");
                ret.owner = new NameUUIDPair(name, uuid);
            }
            ListTag friends = tag.m_128437_("Friends", 10);
            ret.friends = new ArrayList(friends.size());
            for (int i = 0; i < friends.size(); ++i) {
                CompoundTag nf = friends.m_128728_(i);
                NameUUIDPair pair = new NameUUIDPair(nf.m_128461_("Name"), nf.m_128342_("UUID"));
                ret.friends.add(pair);
            }
            ret.friendRights = tag.m_128445_("FriendRights");
            ret.otherRights = tag.m_128445_("OtherRights");
            ListTag upgrades = tag.m_128437_("Upgrades", 10);
            ret.upgrades = new ArrayList();
            for (int i = 0; i < upgrades.size(); ++i) {
                ret.upgrades.add(ItemStack.m_41712_((CompoundTag)upgrades.m_128728_(i)));
            }
            if (tag.m_128441_("AutoVolume")) {
                ret.autoVolume = tag.m_128471_("AutoVolume");
            }
            return ret;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Side", (byte)this.side.ordinal());
            tag.m_128405_("Width", this.size.x);
            tag.m_128405_("Height", this.size.y);
            tag.m_128405_("ResolutionX", this.resolution.x);
            tag.m_128405_("ResolutionY", this.resolution.y);
            tag.m_128344_("Rotation", (byte)this.rotation.ordinal());
            tag.m_128359_("URL", this.url);
            if (this.owner == null) {
                Log.warning("Found TES with NO OWNER!!", new Object[0]);
            } else {
                tag.m_128359_("OwnerName", this.owner.name);
                tag.m_128362_("OwnerUUID", this.owner.uuid);
            }
            ListTag list = new ListTag();
            for (NameUUIDPair f : this.friends) {
                CompoundTag nf = new CompoundTag();
                nf.m_128359_("Name", f.name);
                nf.m_128362_("UUID", f.uuid);
                list.add((Object)nf);
            }
            tag.m_128365_("Friends", (Tag)list);
            tag.m_128344_("FriendRights", (byte)this.friendRights);
            tag.m_128344_("OtherRights", (byte)this.otherRights);
            list = new ListTag();
            for (ItemStack is : this.upgrades) {
                list.add((Object)is.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("Upgrades", (Tag)list);
            tag.m_128379_("AutoVolume", this.autoVolume);
            return tag;
        }

        public int rightsFor(Player ply) {
            return this.rightsFor(ply.m_36316_().getId());
        }

        public int rightsFor(UUID uuid) {
            if (this.owner.uuid.equals(uuid)) {
                return 255;
            }
            return this.friends.stream().anyMatch(f -> f.uuid.equals(uuid)) ? this.friendRights : this.otherRights;
        }

        public void setupRedstoneStatus(Level world, BlockPos start) {
            if (world.m_5776_()) {
                Log.warning("Called Screen.setupRedstoneStatus() on client.", new Object[0]);
                return;
            }
            if (this.redstoneStatus != null) {
                Log.warning("Called Screen.setupRedstoneStatus() on server, but redstone status is non-null", new Object[0]);
                return;
            }
            Direction[] VALUES = Direction.values();
            this.redstoneStatus = new NibbleArray(this.size.x * this.size.y);
            Direction facing = VALUES[this.side.reverse().ordinal()];
            ScreenIterator it = new ScreenIterator(start, this.side, this.size);
            while (it.hasNext()) {
                int idx = it.getIndex();
                this.redstoneStatus.set(idx, world.m_46681_(it.next(), facing));
            }
        }

        public void clampResolution() {
            if (this.resolution.x > CommonConfig.Screen.maxResolutionX) {
                float newY = (float)this.resolution.y * (float)CommonConfig.Screen.maxResolutionX / (float)this.resolution.x;
                this.resolution.x = CommonConfig.Screen.maxResolutionX;
                this.resolution.y = (int)newY;
            }
            if (this.resolution.y > CommonConfig.Screen.maxResolutionY) {
                float newX = (float)this.resolution.x * (float)CommonConfig.Screen.maxResolutionY / (float)this.resolution.y;
                this.resolution.x = (int)newX;
                this.resolution.y = CommonConfig.Screen.maxResolutionY;
            }
        }

        public void createBrowser(boolean doAnim) {
            SharedProxy sharedProxy = WebDisplays.PROXY;
            if (sharedProxy instanceof ClientProxy) {
                ClientProxy clientProxy = (ClientProxy)sharedProxy;
                this.browser = clientProxy.getMCEF().createBrowser(WebDisplays.applyBlacklist(this.url != null ? this.url : "https://www.google.com"));
                if (this.rotation.isVertical) {
                    this.browser.resize(this.resolution.y, this.resolution.x);
                } else {
                    this.browser.resize(this.resolution.x, this.resolution.y);
                }
                if (WebDisplays.cursorSupport) {
                    this.browser.addCursorChangeListener(type -> {
                        this.mouseType = type;
                    });
                }
                this.doTurnOnAnim = doAnim;
                this.turnOnTime = System.currentTimeMillis();
            }
        }
    }
}

